// Get the browser API (Chrome or Firefox)
const browserAPI = typeof browser !== 'undefined' ? browser : chrome;

// Handle keyboard shortcut command
browserAPI.commands.onCommand.addListener((command) => {
  if (command === 'open-popup') {
    // Use action API (Manifest V3) or browserAction API (Manifest V2/Firefox)
    const actionAPI = browserAPI.action || browserAPI.browserAction;
    
    // Try to open popup directly (Firefox supports this in Manifest V2)
    if (actionAPI && actionAPI.openPopup) {
      actionAPI.openPopup();
    } else {
      // For Chrome Manifest V3 or if openPopup is not available, open as a small popup window
      const popupUrl = browserAPI.runtime.getURL('browserAction/index.html');
      
      // Try to create a small popup window
      if (browserAPI.windows) {
        browserAPI.windows.create({
          url: popupUrl,
          type: 'popup',
          width: 420,
          height: 620
        });
      } else {
        // Fallback: open in new tab
        browserAPI.tabs.create({
          url: popupUrl,
          active: true
        });
      }
    }
  }
});
